#include <bits/stdc++.h>
using namespace std;

struct Jarbol {
    int visina;
    int mesto;
    int broj;
};

struct Kandidat {
    int mesto;
    int visina;
    int broj;

    bool operator<(const Kandidat& other) const {
        return mesto < other.mesto;
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;

    multiset<Kandidat> skup;
    vector<int> izlaz(n);
    vector<Jarbol> jarbol(n);

    // Ucitavanje mesta i dodela broja
    for (int i = 0; i < n; i++) {
        cin >> jarbol[i].mesto;
        jarbol[i].broj = i;
    }

    // Ucitavanje visine
    for (int i = 0; i < n; i++) {
        cin >> jarbol[i].visina;
    }

    int br = n - 1;

    // Sortiranje jarbola po mestu
    sort(jarbol.begin(), jarbol.end(), [](const Jarbol& a, const Jarbol& b) {
        return a.mesto < b.mesto;
    });

    while (br >= 0) {
        int k = 1;
        skup.insert({jarbol[br].mesto, jarbol[br].visina, jarbol[br].broj});

        // Dodavanje svih jarbola iste visine
        while (br - k >= 0 && jarbol[br - k].visina == jarbol[br].visina) {
            skup.insert({jarbol[br - k].mesto, jarbol[br - k].visina, jarbol[br - k].broj});
            k++;
        }

        // Obrada svakog jarbola iste visine
        for (int i = 0; i < k; i++) {
            if(skup.size()==1)
                izlaz[jarbol[br - i].broj] =-1;
            else{
                Kandidat pot1, pot2;
                bool dva = false;
                int jed;

                Kandidat target;
                target.mesto = jarbol[br - i].mesto;

                auto it = skup.lower_bound(target);

                if (next(it) == skup.end()) {
                    pot1 = *prev(it);
                } else if (it == skup.begin()) {
                    pot1 = *next(it);
                } else {
                    pot1 = *next(it);
                    pot2 = *prev(it);
                    dva = true;
                }
                jed = abs(jarbol[br - i].mesto - pot1.mesto) + jarbol[br - i].visina - pot1.visina;
                if (dva) {
                    jed = min(jed, abs(jarbol[br - i].mesto - pot2.mesto) + jarbol[br - i].visina - pot2.visina);
                }
                izlaz[jarbol[br - i].broj] = jed;
            }
        }
        br -= k;
    }

    for (int i = 0; i < n; i++) {
        cout << izlaz[i] << endl;
    }

    return 0;
}